# frozen_string_literal: true

module Gitlab
  module DataBuilder
    module Vulnerability
      extend self

      def build(vulnerability)
        {
          object_kind: 'vulnerability',
          object_attributes: hook_attrs(vulnerability)
        }
      end

      def hook_attrs(vulnerability)
        {
          url: ::Gitlab::Routing.url_helpers.project_security_vulnerability_url(vulnerability.project, vulnerability),
          title: vulnerability.title,
          state: vulnerability.state,
          severity: vulnerability.severity,
          severity_overridden: vulnerability.severity_overridden,
          identifiers: identifiers_hook_attrs(vulnerability.identifiers),
          report_type: vulnerability.report_type,
          confidence: vulnerability.confidence,
          confidence_overridden: vulnerability.confidence_overridden,
          dismissed_at: vulnerability.dismissed_at,
          dismissed_by_id: vulnerability.dismissed_by_id
        }
      end

      def identifiers_hook_attrs(identifiers)
        return [] unless identifiers

        identifiers.map do |identifier|
          {
            name: identifier.name,
            external_id: identifier.external_id,
            external_type: identifier.external_type,
            url: identifier.url
          }
        end
      end
    end
  end
end
