# frozen_string_literal: true

module VulnerabilityIssueLinks
  class DeleteService < BaseService
    def initialize(user, vulnerability_issue_link)
      @user = user
      @link = vulnerability_issue_link
    end

    def execute
      raise Gitlab::Access::AccessDeniedError unless can?(user, :admin_vulnerability_issue_link, link)

      link.destroy!

      success
    end

    private

    attr_reader :user, :link

    def success
      ServiceResponse.success(payload: { record: link }, http_status: 200)
    end
  end
end
