# frozen_string_literal: true

module Security
  module Ingestion
    module Tasks
      class UpdateVulnerabilityUuids
        class VulnerabilityFeedback
          include Gitlab::Ingestion::BulkUpdatableTask

          self.model = Vulnerabilities::Feedback

          def initialize(uuid_hash_lookup, project)
            @uuid_hash_lookup = uuid_hash_lookup
            @project = project
          end

          private

          attr_reader :project, :uuid_hash_lookup

          def attributes
            project
              .vulnerability_feedback
              .by_finding_uuid(uuid_hash_lookup.keys)
              .map { |vf| attributes_for(vf, uuid_hash_lookup[vf.finding_uuid]) }
          end

          def attributes_for(vulnerability_feedback, new_uuid)
            {
              id: vulnerability_feedback.id,
              finding_uuid: new_uuid
            }
          end
        end
      end
    end
  end
end
