# frozen_string_literal: true

module Types
  module VulnerabilityLocation
    # rubocop: disable Graphql/AuthorizeTypes
    class DependencyScanningType < BaseObject
      graphql_name 'VulnerabilityLocationDependencyScanning'
      description 'Represents the location of a vulnerability found by a dependency security scan'

      field :dependency, ::Types::VulnerableDependencyType,
        null: true, description: 'Dependency containing the vulnerability.'

      field :file, GraphQL::Types::String,
        null: true, description: 'Path to the vulnerable file.'

      field :blob_path, GraphQL::Types::String,
        null: true, description: 'Blob path to the vulnerable file.'
    end
  end
end
