# frozen_string_literal: true

module Types
  module Vulnerability
    class ExternalIssueLinkType < BaseObject
      graphql_name 'VulnerabilityExternalIssueLink'
      description 'Represents an external issue link of a vulnerability'

      authorize :read_security_resource

      field :id, GlobalIDType[::Vulnerabilities::ExternalIssueLink],
        null: false,
        description: 'GraphQL ID of the external issue link.'

      field :link_type, ::Types::Vulnerability::ExternalIssueLinkTypeEnum,
        null: false,
        description: 'Type of the external issue link.'

      field :external_issue, ::Types::ExternalIssueType,
        null: true,
        resolver: Resolvers::ExternalIssueResolver,
        description: 'The external issue attached to the issue link.'
    end
  end
end
