# frozen_string_literal: true

class ScheduleMigrateSharedVulnerabilityIdentifiers < Gitlab::Database::Migration[2.1]
  MIGRATION = "MigrateSharedVulnerabilityIdentifiers"
  TABLE_NAME = :vulnerability_occurrences
  BATCH_COLUMN = :id
  DELAY_INTERVAL = 2.minutes

  BATCH_SIZE = 1_000
  SUB_BATCH_SIZE = 100

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  def up
    queue_batched_background_migration(MIGRATION,
      TABLE_NAME,
      BATCH_COLUMN,
      job_interval: DELAY_INTERVAL,
      batch_size: BATCH_SIZE,
      sub_batch_size: SUB_BATCH_SIZE)
  end

  def down
    delete_batched_background_migration(MIGRATION, TABLE_NAME, BATCH_COLUMN, [])
  end
end
