# frozen_string_literal: true

class AddTempIndexOnOverlongVulnerabilityHtmlTitle < Gitlab::Database::Migration[2.0]
  INDEX_NAME = 'tmp_index_vulnerability_overlong_title_html'

  disable_ddl_transaction!

  def up
    # Temporary index to speed up the truncation of vulnerabilities with invalid html title length
    add_concurrent_index :vulnerabilities, [:id],
      name: INDEX_NAME,
      where: "LENGTH(title_html) > 800"
  end

  def down
    remove_concurrent_index_by_name :vulnerabilities, INDEX_NAME
  end
end
