# frozen_string_literal: true

class RemoveCiPipelinesVulnerabilityOccurrencePipelinesPipelineIdFk < Gitlab::Database::Migration[1.0]
  disable_ddl_transaction!

  def up
    with_lock_retries do
      execute('LOCK ci_pipelines, vulnerability_occurrence_pipelines IN ACCESS EXCLUSIVE MODE')

      remove_foreign_key_if_exists(:vulnerability_occurrence_pipelines, :ci_pipelines, name: "fk_rails_6421e35d7d")
    end
  end

  def down
    add_concurrent_foreign_key(:vulnerability_occurrence_pipelines, :ci_pipelines, name: "fk_rails_6421e35d7d", column: :pipeline_id, target_column: :id, on_delete: :cascade)
  end
end
