# frozen_string_literal: true

class AddIndexToVulnerabilityFeedbackFindingUuid < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_feedback_finding_uuid'

  # We are indexing on UUID, a hash index should be smaller and faster
  # details on https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86808#note_943330140
  def up
    add_concurrent_index :vulnerability_feedback, :finding_uuid, using: :hash, name: INDEX_NAME
  end

  def down
    remove_concurrent_index :vulnerability_feedback, :finding_uuid, using: :hash, name: INDEX_NAME
  end
end
