# frozen_string_literal: true

class ScheduleSetCorrectVulnerabilityState < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_main

  MAX_BATCH_SIZE = 5_000
  JOB_INTERVAL = 2.minutes
  MIGRATION_NAME = 'SetCorrectVulnerabilityState'
  BATCH_CLASS_NAME = 'DismissedVulnerabilitiesStrategy'
  SUB_BATCH_SIZE = 100

  def up
    queue_batched_background_migration(
      MIGRATION_NAME,
      :vulnerabilities,
      :id,
      job_interval: JOB_INTERVAL,
      batch_size: MAX_BATCH_SIZE,
      max_batch_size: MAX_BATCH_SIZE,
      batch_class_name: BATCH_CLASS_NAME,
      sub_batch_size: SUB_BATCH_SIZE
    )
  end

  def down
    delete_batched_background_migration(MIGRATION_NAME, :vulnerabilities, :id, [])
  end
end
