# frozen_string_literal: true

module Clusters
  class AgentTokensFinder
    include FinderMethods

    def initialize(agent, current_user, params = {})
      @agent = agent
      @current_user = current_user
      @params = params
    end

    def execute
      return ::Clusters::AgentToken.none unless can_read_cluster_agent?

      agent.agent_tokens.then { |agent_tokens| by_status(agent_tokens) }
    end

    private

    attr_reader :agent, :current_user, :params

    def by_status(agent_tokens)
      params[:status].present? ? agent_tokens.with_status(params[:status]) : agent_tokens
    end

    def can_read_cluster_agent?
      current_user&.can?(:read_cluster_agent, agent)
    end
  end
end
