# frozen_string_literal: true

module Security
  module Ingestion
    module Tasks
      class UpdateVulnerabilityUuids
        class VulnerabilityFindings
          include Gitlab::Ingestion::BulkUpdatableTask

          self.model = Vulnerabilities::Finding

          def initialize(uuid_hash_lookup, project)
            @uuid_hash_lookup = uuid_hash_lookup
            @project = project
          end

          private

          attr_reader :project, :uuid_hash_lookup

          def attributes
            project
              .vulnerability_findings
              .by_uuid(uuid_hash_lookup.keys)
              .map { |vf| attributes_for(vf, uuid_hash_lookup[vf.uuid]) }
          end

          def attributes_for(vulnerability_finding, new_uuid)
            {
              id: vulnerability_finding.id,
              uuid: new_uuid
            }
          end
        end
      end
    end
  end
end
