# frozen_string_literal: true

module Types
  # rubocop: disable Graphql/AuthorizeTypes
  class VulnerabilityEvidenceSupportingMessageType < BaseObject
    graphql_name 'VulnerabilityEvidenceSupportingMessage'
    description 'Represents a vulnerability evidence supporting message'

    field :name,
          GraphQL::Types::String,
          null: false,
          description: 'Name of the vulnerability supporting message.'

    field :request,
          VulnerabilityRequestType,
          null: true,
          description: 'HTTP request of the vulnerability evidence supporting message.'

    field :response,
          VulnerabilityResponseType,
          null: true,
          description: 'HTTP response of the vulnerability evidence supporting message.'
  end
  # rubocop: enable Graphql/AuthorizeTypes
end
