# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class DiffType < BaseType
      graphql_name 'VulnerabilityDetailDiff'
      description 'Represents the vulnerability details diff field'

      field :before, GraphQL::Types::String,
        null: false, description: 'Value of the field before the change.'

      field :after, GraphQL::Types::String,
        null: false, description: 'Value of the field after the change.'
    end
  end
end
