# frozen_string_literal: true

class AddTmpPartialIndexOnVulnerabilityReportTypes2 < Gitlab::Database::Migration[2.1]
  INDEX_NAME = 'tmp_idx_vulnerability_occurrences_on_id_where_report_type_7_99'
  CLAUSE = 'report_type IN (7, 99)'

  def up
    return if index_exists?(:vulnerability_occurrences, :id, name: INDEX_NAME)

    # Temporary index to be removed in 16.1 https://gitlab.com/gitlab-org/gitlab/-/issues/404408
    prepare_async_index :vulnerability_occurrences, :id, where: CLAUSE, name: INDEX_NAME
  end

  def down
    unprepare_async_index :vulnerability_occurrences, :id, name: INDEX_NAME
  end
end
