# frozen_string_literal: true

class RemoveTemporaryVulnerabilityOccurrencesDeduplicationIndex < Gitlab::Database::Migration[1.0]
  MIGRATION = 'RecalculateVulnerabilitiesOccurrencesUuid'
  INDEX_NAME = 'tmp_idx_deduplicate_vulnerability_occurrences'

  disable_ddl_transaction!

  def up
    finalize_background_migration(MIGRATION)

    remove_concurrent_index_by_name(:vulnerability_occurrences, INDEX_NAME)
  end

  def down
    add_concurrent_index :vulnerability_occurrences,
      %i[project_id report_type location_fingerprint primary_identifier_id id],
      name: INDEX_NAME
  end
end
