# frozen_string_literal: true

module Enums
  module Vulnerability
    CONFIDENCE_LEVELS = {
      # undefined: 0, no longer applicable
      ignore: 1,
      unknown: 2,
      experimental: 3,
      low: 4,
      medium: 5,
      high: 6,
      confirmed: 7
    }.with_indifferent_access.freeze

    REPORT_TYPES = {
      sast: 0,
      secret_detection: 4
    }.with_indifferent_access.freeze

    SEVERITY_LEVELS = {
      # undefined: 0, no longer applicable
      info: 1,
      unknown: 2,
      # experimental: 3, formerly used by confidence, no longer applicable
      low: 4,
      medium: 5,
      high: 6,
      critical: 7
    }.with_indifferent_access.freeze

    DETECTION_METHODS = {
      gitlab_security_report: 0,
      external_security_report: 1,
      bug_bounty: 2,
      code_review: 3,
      security_audit: 4
    }.with_indifferent_access.freeze

    # keep the order of the values in the state enum, it is used in state_order method to properly order vulnerabilities based on state
    # remember to recreate index_vulnerabilities_on_state_case_id index when you update or extend this enum
    VULNERABILITY_STATES = {
      detected: 1,
      confirmed: 4,
      resolved: 3,
      dismissed: 2
    }.with_indifferent_access.freeze

    def self.confidence_levels
      CONFIDENCE_LEVELS
    end

    def self.report_types
      REPORT_TYPES
    end

    def self.severity_levels
      SEVERITY_LEVELS
    end

    def self.detection_methods
      DETECTION_METHODS
    end

    def self.vulnerability_states
      VULNERABILITY_STATES
    end
  end
end

Enums::Vulnerability.prepend_mod_with('Enums::Vulnerability')
