require "krb5_auth"
# This calls helps to authenticate to Kerberos by providing username and password

module Gitlab
  module Kerberos
    class Authentication
      def self.kerberos_default_realm
        krb5 = ::Krb5Auth::Krb5.new
        default_realm = krb5.get_default_realm
        krb5.close # release memory allocated by the krb5 library
        default_realm
      end

      def self.login(login, password)
        return unless Devise.omniauth_providers.include?(:kerberos)
        return unless login.present? && password.present?

        auth = new(login, password)
        auth.login
      end

      def initialize(login, password)
        @login = login
        @password = password
        @krb5 = ::Krb5Auth::Krb5.new
      end

      def valid?
        @krb5.get_init_creds_password(@login, @password)
      rescue ::Krb5Auth::Krb5::Exception
        false
      end

      def login
        # get_default_principal consistently returns the canonical Kerberos principal name, with realm
        valid? && find_by_login(@krb5.get_default_principal)
      end

      private

      def find_by_login(login)
        identity = ::Identity.find_by(provider: :kerberos, extern_uid: login)
        identity && identity.user
      end
    end
  end
end
