module Gitlab
  class AuthorityAnalyzer
    COMMITS_TO_CONSIDER = 5

    def initialize(merge_request, current_user)
      @merge_request = merge_request
      @current_user = current_user
      @users = Hash.new(0)
    end

    def calculate(number_of_approvers)
      involved_users

      # Picks most active users from hash like: {user1: 2, user2: 6}
      @users.sort_by { |user, count| count }.map(&:first).take(number_of_approvers)
    end

    private

    def involved_users
      @repo = @merge_request.target_project.repository

      list_of_involved_files.each do |path|
        @repo.commits(@merge_request.target_branch, path, COMMITS_TO_CONSIDER).each do |commit|
          @users[commit.author] += 1 if commit.author
        end
      end
    end

    def list_of_involved_files
      compare_diffs = @merge_request.compare_diffs || @merge_request.diffs

      return [] unless compare_diffs.present?
      
      compare_diffs.map do |diff|
        if diff.deleted_file || diff.renamed_file
          diff.old_path
        else
          diff.new_path
        end
      end
    end
  end
end
