# From Community Edition 7.10 to Enterprise Edition 7.10

This guide assumes you have a correctly configured and tested installation of GitLab Community Edition 7.10.
If you run into any trouble or if you have any questions please contact us at support@gitlab.com.

### 0. Backup

Make a backup just in case things go south:
(With MySQL, this may require granting "LOCK TABLES" privileges to the GitLab user on the database version)

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

### 1. Stop server

    sudo service gitlab stop

### 2. Get the EE code

```bash
cd /home/git/gitlab
sudo -u git -H git remote add ee https://gitlab.com/subscribers/gitlab-ee.git
sudo -u git -H git fetch --all
sudo -u git -H git checkout 7-10-stable-ee
```

### 3. Update config files

* Make `/home/git/gitlab/config/gitlab.yml` same as /home/git/gitlab/config/gitlab.yml.example but with your settings.

### 4. Install libs, migrations, etc.

```bash
cd /home/git/gitlab

# MySQL
sudo -u git -H bundle install --without development test postgres --deployment

#PostgreSQL
sudo -u git -H bundle install --without development test mysql --deployment

sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production
```

### 5. Start application

    sudo service gitlab start
    sudo service nginx restart

### 6. Check application status

Check if GitLab and its environment are configured correctly:

    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade complete!

## Things went wrong? Revert to previous version (Community Edition 7.10)

### 1. Revert the code to the previous version
```bash
cd /home/git/gitlab
sudo -u git -H git checkout 7-10-stable
```

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```
