# From 6.x or 7.x to 7.14
*Make sure you view this [upgrade guide from the `master` branch](../../../master/doc/update/6.x-or-7.x-to-7.14.md) for the most up to date instructions.*

This allows you to upgrade any version of GitLab from 6.0 and up (including 7.0 and up) to 7.14.

## Global issue numbers

As of 6.1 issue numbers are project specific. This means all issues are renumbered and get a new number in their URL. If you use an old issue number URL and the issue number does not exist yet you are redirected to the new one. This conversion does not trigger if the old number already exists for this project, this is unlikely but will happen with old issues and large projects.

## Editable labels

In GitLab 7.2 we replace Issue and Merge Request tags with labels, making it
possible to edit the label text and color. The characters `?`, `&` and `,` are
no longer allowed however so those will be removed from your tags during the
database migrations for GitLab 7.2.

## Stash changes

If you [deleted the vendors folder during your original installation](https://github.com/gitlabhq/gitlabhq/issues/4883#issuecomment-31108431), [you will get an error](https://gitlab.com/gitlab-org/gitlab-ce/issues/1494) when you attempt to rebuild the assets in step 7. To avoid this, stash the changes in your GitLab working copy before starting:

    git stash

## 0. Stop server

    sudo service gitlab stop

## 1. Backup

It's useful to make a backup just in case things go south:
(With MySQL, this may require granting "LOCK TABLES" privileges to the GitLab user on the database version)

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
```

## 2. Update Ruby

If you are still using Ruby 1.9.3 or below, you will need to update Ruby.
You can check which version you are running with `ruby -v`.

If you are you running Ruby 2.0.x, you do not need to upgrade ruby, but can consider doing so for performance reasons.

If you are running Ruby 2.1.1 consider upgrading to 2.1.6, because of the high memory usage of Ruby 2.1.1.

Install, update dependencies:

```bash
sudo apt-get install build-essential zlib1g-dev libyaml-dev libssl-dev libgdbm-dev libreadline-dev libncurses5-dev libffi-dev curl
```

Download and compile Ruby:

```bash
mkdir /tmp/ruby && cd /tmp/ruby
curl --progress https://cache.ruby-lang.org/pub/ruby/2.1/ruby-2.1.6.tar.gz | tar xz
cd ruby-2.1.6
./configure --disable-install-rdoc
make
sudo make install
```

Install Bundler:

```bash
sudo gem install bundler --no-ri --no-rdoc
```

## 3. Get latest code

```bash
cd /home/git/gitlab
sudo -u git -H git fetch --all
sudo -u git -H git checkout -- db/schema.rb # local changes will be restored automatically
```

For GitLab Community Edition:

```bash
sudo -u git -H git checkout 7-14-stable
```

OR

For GitLab Enterprise Edition:

```bash
sudo -u git -H git checkout 7-14-stable-ee
```

## 4. Install additional packages

```bash
# Add support for logrotate for better log file handling
sudo apt-get install logrotate

# Install pkg-config and cmake, which is needed for the latest versions of rugged
sudo apt-get install pkg-config cmake

# If you want to use Kerberos with GitLab EE for user authentication, install Kerberos header files
# If you don't know what Kerberos is, you can assume you don't need it.
sudo apt-get install libkrb5-dev

# Install nodejs, javascript runtime required for assets
sudo apt-get install nodejs
```

## 5. Configure Redis to use sockets

    # Configure redis to use sockets
    sudo cp /etc/redis/redis.conf /etc/redis/redis.conf.orig
    # Disable Redis listening on TCP by setting 'port' to 0
    sed 's/^port .*/port 0/' /etc/redis/redis.conf.orig | sudo tee /etc/redis/redis.conf
    # Enable Redis socket for default Debian / Ubuntu path
    echo 'unixsocket /var/run/redis/redis.sock' | sudo tee -a /etc/redis/redis.conf
    # Be sure redis group can write to the socket, enable only if supported (>= redis 2.4.0).
    sudo sed -i '/# unixsocketperm/ s/^# unixsocketperm.*/unixsocketperm 0775/' /etc/redis/redis.conf
    # Activate the changes to redis.conf
    sudo service redis-server restart
    # Add git to the redis group
    sudo usermod -aG redis git

    # Configure Redis connection settings
    sudo -u git -H cp config/resque.yml.example config/resque.yml
    # Change the Redis socket path if you are not using the default Debian / Ubuntu configuration
    sudo -u git -H editor config/resque.yml

    # Configure gitlab-shell to use Redis sockets
    sudo -u git -H sed -i 's|^  # socket.*|  socket: /var/run/redis/redis.sock|' /home/git/gitlab-shell/config.yml

## 6. Update gitlab-shell

```bash
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v2.6.5
```

## 7. Install libs, migrations, etc.

```bash
sudo apt-get install libkrb5-dev

cd /home/git/gitlab

# MySQL installations (note: the line below states '--without ... postgres')
sudo -u git -H bundle install --without development test postgres --deployment

# PostgreSQL installations (note: the line below states '--without ... mysql')
sudo -u git -H bundle install --without development test mysql --deployment

# Run database migrations
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production

# Enable internal issue IDs (introduced in GitLab 6.1)
sudo -u git -H bundle exec rake migrate_iids RAILS_ENV=production

# Clean up assets and cache
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production

# Close access to gitlab-satellites for others
sudo chmod u+rwx,g+rx,o-rwx /home/git/gitlab-satellites

# Update init.d script
sudo cp lib/support/init.d/gitlab /etc/init.d/gitlab
```

## 8. Update config files

TIP: to see what changed in `gitlab.yml.example` in this release use next command:

```
git diff 6-0-stable:config/gitlab.yml.example 7-14-stable-ee:config/gitlab.yml.example
```

* Make `/home/git/gitlab/config/gitlab.yml` the same as https://gitlab.com/gitlab-org/gitlab-ee/blob/7-14-stable-ee/config/gitlab.yml.example but with your settings.
* Make `/home/git/gitlab/config/unicorn.rb` the same as https://gitlab.com/gitlab-org/gitlab-ee/blob/7-14-stable-ee/config/unicorn.rb.example but with your settings.
* Make `/home/git/gitlab-shell/config.yml` the same as https://gitlab.com/gitlab-org/gitlab-shell/blob/v2.6.5/config.yml.example but with your settings.
* Copy rack attack middleware config

```bash
sudo -u git -H cp config/initializers/rack_attack.rb.example config/initializers/rack_attack.rb
```

* Set up logrotate

```bash
sudo cp lib/support/logrotate/gitlab /etc/logrotate.d/gitlab
```

### Change Nginx settings

* HTTP setups: Make `/etc/nginx/sites-available/gitlab` the same as https://gitlab.com/gitlab-org/gitlab-ee/blob/7-14-stable-ee/lib/support/nginx/gitlab but with your settings.
* HTTPS setups: Make `/etc/nginx/sites-available/gitlab-ssl` the same as https://gitlab.com/gitlab-org/gitlab-ee/blob/7-14-stable-ee/lib/support/nginx/gitlab-ssl but with your settings.
* A new `location /uploads/` section has been added that needs to have the same content as the existing `location @gitlab` section.

### Check the version of /usr/local/bin/git

If you installed Git from source into /usr/local/bin/git then please [check
your version](7.13-to-7.14.md).

## 9. Start application

    sudo service gitlab start
    sudo service nginx restart

## 10. Check application status

Check if GitLab and its environment are configured correctly:

    cd /home/git/gitlab
    sudo -u git -H bundle exec rake gitlab:env:info RAILS_ENV=production

To make sure you didn't miss anything run a more thorough check with:

    sudo -u git -H bundle exec rake gitlab:check RAILS_ENV=production

If all items are green, then congratulations upgrade complete!

## 11. Update OmniAuth configuration

When using Google omniauth login, changes of the Google account required.
Ensure that `Contacts API` and the `Google+ API` are enabled in the [Google Developers Console](https://console.developers.google.com/).
More details can be found at the [integration documentation](../../../master/doc/integration/google.md).

## 12. Optional optimizations for GitLab setups with MySQL databases

Only applies if running MySQL database created with GitLab 6.7 or earlier. If you are not experiencing any issues you may not need the following instructions however following them will bring your database in line with the latest recommended installation configuration and help avoid future issues. Be sure to follow these directions exactly. These directions should be safe for any MySQL instance but to be sure make a current MySQL database backup beforehand.

```
# Stop GitLab
sudo service gitlab stop

# Secure your MySQL installation (added in GitLab 6.2)
sudo mysql_secure_installation

# Login to MySQL
mysql -u root -p

# do not type the 'mysql>', this is part of the prompt

# Convert all tables to use the InnoDB storage engine (added in GitLab 6.8)
SELECT CONCAT('ALTER TABLE gitlabhq_production.', table_name, ' ENGINE=InnoDB;') AS 'Copy & run these SQL statements:' FROM information_schema.tables WHERE table_schema = 'gitlabhq_production' AND `ENGINE` <> 'InnoDB' AND `TABLE_TYPE` = 'BASE TABLE';

# If previous query returned results, copy & run all shown SQL statements

# Convert all tables to correct character set
SET foreign_key_checks = 0;
SELECT CONCAT('ALTER TABLE gitlabhq_production.', table_name, ' CONVERT TO CHARACTER SET utf8 COLLATE utf8_general_ci;') AS 'Copy & run these SQL statements:' FROM information_schema.tables WHERE table_schema = 'gitlabhq_production' AND `TABLE_COLLATION` <> 'utf8_unicode_ci' AND `TABLE_TYPE` = 'BASE TABLE';

# If previous query returned results, copy & run all shown SQL statements

# turn foreign key checks back on
SET foreign_key_checks = 1;

# Find MySQL users
mysql> SELECT user FROM mysql.user WHERE user LIKE '%git%';

# If git user exists and gitlab user does not exist
# you are done with the database cleanup tasks
mysql> \q

# If both users exist skip to Delete gitlab user

# Create new user for GitLab (changed in GitLab 6.4)
# change $password in the command below to a real password you pick
mysql> CREATE USER 'git'@'localhost' IDENTIFIED BY '$password';

# Grant the git user necessary permissions on the database
mysql> GRANT SELECT, INSERT, UPDATE, DELETE, CREATE, DROP, INDEX, ALTER, LOCK TABLES ON `gitlabhq_production`.* TO 'git'@'localhost';

# Delete the old gitlab user
mysql> DELETE FROM mysql.user WHERE user='gitlab';

# Quit the database session
mysql> \q

# Try connecting to the new database with the new user
sudo -u git -H mysql -u git -p -D gitlabhq_production

# Type the password you replaced $password with earlier

# You should now see a 'mysql>' prompt

# Quit the database session
mysql> \q

# Update database configuration details
# See config/database.yml.mysql for latest recommended configuration details
#   Remove the reaping_frequency setting line if it exists (removed in GitLab 6.8)
#   Set production -> pool: 10 (updated in GitLab 5.3)
#   Set production -> username: git
#   Set production -> password: the password your replaced $password with earlier
sudo -u git -H editor /home/git/gitlab/config/database.yml
```

## Things went south? Revert to previous version (7.0)

### 1. Revert the code to the previous version

Follow the [upgrade guide from 6.9 to 7.0](6.9-to-7.0.md), except for the database migration (the backup is already migrated to the previous version).

### 2. Restore from the backup:

```bash
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:restore RAILS_ENV=production
```

## Login issues after upgrade?

If running in HTTPS mode, be sure to read [Can't Verify CSRF token authenticity](https://github.com/gitlabhq/gitlab-public-wiki/wiki/Trouble-Shooting-Guide#cant-verify-csrf-token-authenticitycant-get-past-login-pageredirected-to-login-page)
