"""create basic models

Revision ID: 04ce0e98d80e
Revises:
Create Date: 2025-11-29 01:35:59.055199

"""
from __future__ import annotations

from typing import TYPE_CHECKING

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects.postgresql import ENUM

if TYPE_CHECKING:
    from collections.abc import Sequence

# revision identifiers, used by Alembic.
revision: str = "04ce0e98d80e"
down_revision: str | None = None
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None

upload_status = ENUM("PROCESSING", "DONE", "ERROR", name="uploadstatus", create_type=False)
text_status = ENUM("NEW", "PROCESSING", "DONE", "ERROR", name="textstatus", create_type=False)

def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    upload_status.create(op.get_bind(), checkfirst=True)
    text_status.create(op.get_bind(), checkfirst=True)
    op.create_table("uploads",
    sa.Column("upload_id", sa.Integer(), autoincrement=True, nullable=False),
    sa.Column("uploaded_at", sa.DateTime(), nullable=False),
    sa.Column("status", upload_status, nullable=False),
    sa.Column("has_validation", sa.Boolean(), nullable=False),
    sa.Column("filename", sa.String(), nullable=False),
    sa.PrimaryKeyConstraint("upload_id"),
    )
    op.create_table("texts",
    sa.Column("text_id", sa.Integer(), autoincrement=True, nullable=False),
    sa.Column("upload_id", sa.Integer(), nullable=False),
    sa.Column("status", text_status, nullable=False),
    sa.Column("content", sa.String(), nullable=False),
    sa.Column("predicted_label", sa.String(), nullable=True),
    sa.Column("src", sa.String(), nullable=True),
    sa.ForeignKeyConstraint(["upload_id"], ["uploads.upload_id"] ),
    sa.PrimaryKeyConstraint("text_id"),
    )
    op.create_table("validations",
    sa.Column("validation_id", sa.Integer(), autoincrement=True, nullable=False),
    sa.Column("text_id", sa.Integer(), nullable=False),
    sa.Column("label", sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(["text_id"], ["texts.text_id"] ),
    sa.PrimaryKeyConstraint("validation_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("validations")
    op.drop_table("texts")
    op.drop_table("uploads")
    text_status.drop(op.get_bind(), checkfirst=True)
    upload_status.drop(op.get_bind(), checkfirst=True)
    # ### end Alembic commands ###
