def time_string_to_minute(time: str) -> int:
    """
    Возвращает номер минуты текущего времени в сутках
    """
    hrs, mins = map(int, time.split(':'))
    return hrs * 60 + mins


def time_correct(time: str) -> str:
    """
    Приводит время в формат, необходимый для модуля schedule (чч:мм)
    @param time:
    @return:
    """
    if time == '-': return time
    time = time.split(':')
    for i in range(2):
        if len(time[i]) == 1:
            time[i] = '0' + time[i]
    return ':'.join(time)


def time_before(time: str, delay: int) -> str:
    """
    Возвращает время предварительного звонка по заданному времени
    и количеству минут от предварительного до основного звонка
    :param time: str
    :param delay: int
    :return: str
    """
    hrs, mins = map(int, time.split(':'))
    time_in_minutes = (hrs * 60 + mins - delay) % 1440
    hrs, mins = divmod(time_in_minutes, 60)
    return f'{hrs:02}' + ':' + f'{mins:02}'
