import logging
import subprocess

from PyQt5.QtCore import QThread
from PyQt5.QtWidgets import QWidget, QGridLayout, QPushButton

from school_ringer_modules.config import sound_path
from school_ringer_modules.sound import audio_user
from school_ringer_modules.system import run_command


class Recodring(QThread):

    def __init__(self, parent=None):
        QThread.__init__(self, parent)

    def run(self):
        try:
            subprocess.Popen(['runuser', '-l', audio_user(), '-c', f'arecord -f cd {sound_path}/notification.wav'])
        except Exception as e:
            logging.info(f'При попытке записи уведомления возникла ошибка {e}')


class NotificationWindow(QWidget):
    def __init__(self) -> None:
        """
        Конструктор, создающий экземпляр класса
        """
        super().__init__()

        self.current_user = audio_user()
        self.thread = Recodring()
        self.initUI()

    def record_notification(self):
        self.startButton.setEnabled(False)
        self.stopButton.setEnabled(True)
        self.playButton.setEnabled(False)
        self.thread.start()

    def stop_recordind(self):
        logging.info('Остановка записи...')
        self.stopButton.setEnabled(False)
        self.startButton.setEnabled(True)
        self.playButton.setEnabled(True)
        who_records = run_command("ps -e | grep arecord")
        logging.info(f'Вывод команды: {who_records}')
        try:
            pid = who_records.split()[0]
            logging.info(f'При попытке остановить запись был получен PID {pid}')
            run_command(f'kill {pid}')
        except Exception as e:
            logging.info(f'Невозможно остановить arecord, сообщение: {e}')
        self.thread.quit()

    def play_recorded(self):
        self.stopButton.setEnabled(False)
        self.startButton.setEnabled(False)
        try:
            subprocess.Popen(['runuser', '-l', self.current_user, '-c', f'play {sound_path}/notification.wav'])
        except Exception as e:
            logging.info(f'При попытке воспроизвести оповещение возникла ошибка {e}')
        self.startButton.setEnabled(True)

    def initUI(self):
        grid = QGridLayout()
        self.setLayout(grid)
        self.startButton = QPushButton('⏺️ Начать запись')
        self.startButton.setMinimumHeight(50)
        self.startButton.clicked.connect(self.record_notification)
        grid.addWidget(self.startButton)
        self.stopButton = QPushButton('⏹️ Остановить запись')
        self.stopButton.setMinimumHeight(50)
        self.stopButton.clicked.connect(self.stop_recordind)
        self.stopButton.setEnabled(False)
        grid.addWidget(self.stopButton)
        self.playButton = QPushButton('▶️ Воспроизвести оповещение')
        self.playButton.setMinimumHeight(50)
        self.playButton.setDisabled(True)
        self.playButton.clicked.connect(self.play_recorded)
        grid.addWidget(self.playButton)

        self.setWindowTitle('Окно оповещения')
        self.setGeometry(400, 300, 300, 150)
        self.show()

        print('Done')
