# SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
# SPDX-License-Identifier: BSD-3-Clause

from configuration import Configuration
from generators.filegenerator import FileGenerator

class SpecFileGenerator(FileGenerator):
    def __init__(self, config: Configuration, project_dir: str = './') -> None:
        super().__init__(config, project_dir)
        self.path = f"rpm/{self.config.full_name}.spec"

    def generate(self) -> str:
        content =\
f"""\
Name:       {self.config.full_name}
Summary:    {self.config.summary}
Version:    {self.config.version}
Release:    1
Group:      Qt/Qt
License:    BSD-3-Clause
URL:        https://developer.auroraos.ru/open-source
Source0:    %{{name}}-%{{version}}.tar.bz2
Requires:   sailfishsilica-qt5 >= 0.10.9
Requires:   sailfish-components-webview-qt5
Requires:   sailfish-components-webview-qt5-popups
Requires:   sailfish-components-webview-qt5-pickers
"""
        if self.config.push_app_id:
            content +=\
"""
BuildRequires: pkgconfig(pushclient) >= 2.0.0
BuildRequires: pkgconfig(nemonotifications-qt5)
"""
        if self.config.webview_version == "ru.auroraos.WebView":
             content +=\
"""
BuildRequires:  pkgconfig(aurorawebview)
BuildRequires:  pkgconfig(auroraapp)
BuildRequires:  pkgconfig(Qt5Network)
"""
        else:
            content +=\
"""
BuildRequires:  pkgconfig(auroraapp) >= 1.0.2
BuildRequires:  pkgconfig(qt5embedwidget) >= 1.14.9
"""
        content +=\
"""BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Qml)
BuildRequires:  pkgconfig(Qt5Quick)
"""
        if self.config.description:
            content +=\
f"""
%description
{self.config.description}.
"""
        else:
            content +=\
fr"""
%description
%{{summary}}.
"""
        content +=\
fr"""
%prep
%autosetup

%build
%qmake5
%make_build

%install
%make_install

%files
%defattr(-,root,root,-)
%{{_bindir}}/%{{name}}
%defattr(644,root,root,-)
%{{_datadir}}/%{{name}}
%{{_datadir}}/applications/%{{name}}.desktop
%{{_datadir}}/icons/hicolor/*/apps/%{{name}}.png
"""
        return content
