# SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
# SPDX-License-Identifier: BSD-3-Clause

import os
from configuration import Configuration

class FileGenerator:
    def __init__(self, config: Configuration, project_dir: str = './') -> None:
        self.config = config
        self.project_dir = f"{project_dir}/{self.config.application_name}/"
        self.path = None

    def generate(self) -> str:
        raise NotImplementedError

    def save(self) -> None:
        filename = self.project_dir + self.path
        os.makedirs(os.path.dirname(filename), exist_ok=True)
        with open(filename, mode='w', encoding='utf-8') as f:
            f.write(self.generate())
