# SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
# SPDX-License-Identifier: BSD-3-Clause

from configuration import Configuration
from generators.filegenerator import FileGenerator

class DesktopFileGenerator(FileGenerator):
    def __init__(self, config: Configuration, project_dir: str = './') -> None:
        super().__init__(config, project_dir)
        self.path = f"{self.config.full_name}.desktop"

    def generate(self) -> str:
        content =\
f"""\
[Desktop Entry]
Type=Application
X-Nemo-Application-Type=silica-qt5
Icon={self.config.full_name}
Exec=/usr/bin/{self.config.full_name} %u
Name={self.config.application_name}
Name[ru]={self.config.desktop_name}

[X-Application]
Permissions={';'.join(self.config.application_permission)}
OrganizationName={self.config.organization_name}
ApplicationName={self.config.application_name}
ExecDBus=/usr/bin/{self.config.full_name} %u

"""
        return content
