# SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
# SPDX-License-Identifier: BSD-3-Clause

from configuration import Configuration
from generators.filegenerator import FileGenerator

class CoverFileGenerator(FileGenerator):
    def __init__(self, config: Configuration, project_dir: str = './') -> None:
        super().__init__(config, project_dir)
        self.path = f"qml/cover/DefaultCoverPage.qml"

    def generate(self) -> str:
        content =\
f"""\
import QtQuick 2.6
import Sailfish.Silica 1.0

CoverBackground {{
    objectName: "coverBackground"

    CoverPlaceholder {{
        text: qsTr("{self.config.application_name}")
        icon {{
            source: Qt.resolvedUrl("../icons/{self.config.application_name}.svg")
            sourceSize {{ width: icon.width; height: icon.height }}
        }}
        forceFit: true
    }}

}}
"""
        return content
