# SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
# SPDX-License-Identifier: BSD-3-Clause

from configuration import Configuration
from generators.filegenerator import FileGenerator

class ApplicationWindowFileGenerator(FileGenerator):
    def __init__(self, config: Configuration, project_dir: str = './') -> None:
        super().__init__(config, project_dir)
        self.path = f"qml/{self.config.full_name}.qml"

    def generate(self) -> str:
        content = ""
        if self.config.webview_version == "ru.auroraos.WebView":
            content +=\
f"""\
import QtQuick 2.6
import Sailfish.Silica 1.0
import "pages"

ApplicationWindow {{
    id: appWindow

    readonly property string appName: qsTr("{self.config.application_name}")

    objectName: "appWindow"
    allowedOrientations: defaultAllowedOrientations
"""
            if self.config.background_activity:
                content += '    cover: null'
            else:
                content += '    cover: Qt.resolvedUrl("cover/DefaultCoverPage.qml")'
        
            content +=\
"""
    initialPage: Component {
        MainPage {
        }
    }
}
"""
        if self.config.webview_version == "Sailfish.WebView":
            content +=\
"""\
import QtQuick 2.0
import Sailfish.Silica 1.0

ApplicationWindow {
    id: applicationWindow

    objectName: "applicationWindow"
    initialPage: Qt.resolvedUrl("pages/WebViewPage.qml")
"""
            if self.config.background_activity:
                content += '    cover: null'
            else:
                content += '    cover: Qt.resolvedUrl("cover/DefaultCoverPage.qml")'
            
            content +=\
"""
    allowedOrientations: defaultAllowedOrientations
}
"""
            
        return content
