# SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
# SPDX-License-Identifier: BSD-3-Clause

from configuration import Configuration
from generators.filegenerator import FileGenerator

class ConnmanManagerFileGenerator(FileGenerator):
    def __init__(self, config: Configuration, project_dir: str = './') -> None:
        super().__init__(config, project_dir)
        self.path = 'qml/components/ConnmanManager.qml'

    def generate(self) -> str:
        content =\
"""\
import QtQuick 2.0
import Nemo.DBus 2.0

DBusInterface {
    property bool online: true

    function propertyChanged(name, value) {
        if (name === "State")
            online = value === "online";
    }

    bus: DBus.SystemBus
    service: "net.connman"
    path: "/"
    iface: "net.connman.Manager"
    signalsEnabled: true

    Component.onCompleted: {
        call("GetProperties", undefined, function (result) {
                online = result["State"] === "online" || result["State"] == "ready";
            }, function (error, message) {});
    }
}
"""
        return content
