# SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
# SPDX-License-Identifier: BSD-3-Clause

from configuration import Configuration
from generators.filegenerator import FileGenerator

class ConnectionHeaderFileGenerator(FileGenerator):
    def __init__(self, config: Configuration, project_dir: str = './') -> None:
        super().__init__(config, project_dir)
        self.path = 'qml/components/ConnectionHeader.qml'

    def generate(self) -> str:
        content =\
"""\
import QtQuick 2.0
import Sailfish.Silica 1.0

SilicaItem {
    id: connectionHeader

    property bool connected: true

    width: parent.width
    height: 0

    Row {
        anchors.verticalCenter: parent.verticalCenter

        Icon {
            source: "image://theme/icon-m-website?" + Theme.errorColor
        }

        Label {
            text: qsTr("Отсутствует соединение")
            anchors.verticalCenter: parent.verticalCenter
        }
    }

    states: State {
        name: "show"
        when: !connected
        PropertyChanges {
            target: connectionHeader
            height: Theme.iconSizeMedium
        }
    }

    transitions: Transition {
        reversible: true
        NumberAnimation {
            properties: "height"
            easing.type: Easing.InOutQuad
            duration: 200
        }
    }
}
"""
        return content
