# Генератор WebView-приложений

Генератор WebView-приложений предназначен для создания WebView-приложений для ОС Аврора.

## Условия использования и участия

Исходный код проекта предоставляется по [лицензии](LICENSE.BSD-3-Clause.md),
которая позволяет использовать его в сторонних приложениях.

[Соглашение участника](CONTRIBUTING.md) регламентирует права,
предоставляемые участниками компании «Открытая Мобильная Платформа».

Информация об участниках указана в файле [AUTHORS](AUTHORS.md).

[Кодекс поведения](CODE_OF_CONDUCT.md) — это действующий набор правил
компании «Открытая Мобильная Платформа»,
который информирует об ожиданиях по взаимодействию между членами сообщества при общении и работе над проектами.

## Структура проекта

Структура проекта представляет собой набор Python3 скриптов.

* Файл **[generator.py](generator.py)** определяет скрипт для создания приложения с заданными параметрами.
* Файл **[configuration.py](configuration.py)** задает конфигурацию генерируемого приложения.
* Каталог **[default_icons](default_icons)** содержит значки приложения для разных разрешений экрана.
* Каталог **[generators](generators)** содержит шаблоны для создания файлов приложения для всех версий.
* Каталог **[ru_auroraos_WebView](generators/ru_auroraos_WebView)** содержит шаблоны для создания файлов приложения для версии `ru.auroraos.WebView`
* Каталог **[Sailfish_WebView](generators/Sailfish_WebView)** содержит шаблоны для создания файлов приложения для версии `Sailfish.WebView`

## Использование

Для использования генератора приложений необходимо создать конфигурационный JSON-файл, который задаёт свойства, описанные ниже в разделе "Конфигурация". Все свойства, отмеченные как обязательные, должны присутствовать в файле конфигурации.
Запуск выполняется с помощью вызова интерпретатора Python версии 3.6+ с файлом `generator.py` и путём до конфигурационного файла:
```
python <путь до файла generator.py> <путь до конфигурационного файла>
```

Пример:
```
python3 .\generator.py .\template\template.json -p .\template\
```

Результатом будет приложение для ОС Аврора, созданное в соответствии с конфигурацией и включающее следующие элементы:

1. Desktop-файл (`*.desktop`).
2. Spec-файл (`*.spec`).
3. Qml-файл с компонентом WebView.
3. Qml-файл с обложкой приложения.
4. Qml-файлы с вспомогательными компонентами.
5. Иконки приложения (86x86 108x108, 128x128, 172x172). Если путь к значкам не был указан пользователем, то будут использоваться иконки из шаблона.
6. Pro-файл с описанием структуры проекта (`*.pro`).
7. C++ файл с функцией `main()` (`*.cpp`).
8. Файлы с реализацией соответствующей службы D-Bus и Push-клиента (если конфигурационный файл содержит `push_app_id`).

## Конфигурация

Файл конфигурации JSON содержит:

1. Метаинформация:
    1. [application_name] Название приложения (обязательное).
    2. [organization_name] Название организации (обязательное).
    3. [summary] Короткое описание (обязательное).
    4. [version] Версия (обязательное).
    5. [description] Полное описание.
    6. [icon] Путь к значкам приложения, доступных в разрешениях 86x86, 108x108, 128x128 и 172x172.
    7. [application_permission] Список разрешений приложения (обязательное).
    8. [desktop_name] Название приложения, отображаемое под иконкой.
2. [webview_version] Определет какую версию WebView использовать (обязательное):
	* [Sailfish.WebView] Импортировать Webview из Sailfish.Webview
	* [ru.auroraos.WebView] Импортировать Webview из ru.auroraos.WebView
3. [background_activity] Поведение приложения в фоновом режиме (обязательное):
    * [true] Работа в фоновом режиме, отображение содержимого WebView на обложке приложения.
    * [false] Отключение работы в фоновом режиме (очистка содержимого WebView по истечению заданного периода при нахождении приложения в фоновом режиме).
4. [external_urls] Список регулярных выражений для URL, которые будут открываться в системном браузере.
5. [frame_urls] Список регулярных выражений для URL-адресов встроенных в `iframe`, которые будут открыты в WebView.
6. [url] Начальный адрес для отображения в WebView (обязательное).
7. [web_permissions] Белый список разрешений сайта, которые будут автоматически приниматься [геолокация, микрофон, камера, куки, всплывающие окна].
8. [user_agent] Агент пользователя, который будет использоваться WebView вместо стандартного.
9. [push_app_id] Идентификатор приложения для получения push-уведомлений.
10. [push_handler_name] Имя функции JavaScript веб-страницы, на которую будет передано содержимое Push-уведомления.
11. [push_id_injector] Список объектов вида `{"trigger_on": <replaced_url>, "replace_with": <replacement_url>}`, который определяет условия для замены URL-адресов, соответствующих регулярному выражению из `trigger_on` с URL из `replace_with`. Замена происходит, когда пользователь переходит к URL, соответствующему `trigger_on`. Вместо этой страницы будет открыт URL-адрес, указанный в `replace_with`. Если URL-адрес, указанный как `replace_with` содержит символы `"%1"`, то символы будут заменены на идентификатор приложения на push-сервере Аврора ОС.

### Пример

```
{
	"application_name": "DevPortalWEB",
	"organization_name": "auroraos.ru",
	"summary": "A reference WebView wrapper for Aurora OS Developer Portal",
	"version": 1.0,
	"description": "An example of a WebView wrapper generated with a Web App Generator. Provides access to Aurora OS Developer Portal",
	"application_permission":
		[
			"Internet"
		],
	"webview_version": "ru.auroraos.WebView",
	"background_activity": true,
	"url": "https://developer.auroraos.ru/"
}
```

## Сборка

Сгенерированный проект можно использовать точно так же, как созданный вручную или мастером в Aurora OS SDK. Вы можете сразу же собрать или изменить его без помощи генератора.

## This document in English

- [README.md](README.md)

