# WebApp Generator

The WebApp Generator is designed to create WebView applications for Aurora OS.

## Terms of Use and Participation

The source code of the project is provided under [the license](LICENSE.BSD-3-Clause.md),
which allows its use in third-party applications.

The [contributor agreement](CONTRIBUTING.md) documents the rights granted by contributors
of the Open Mobile Platform.

Information about the contributors is specified in the [AUTHORS](AUTHORS.md) file.

[Code of conduct](CODE_OF_CONDUCT.md) is a current set of rules of the Open Mobile
Platform which informs you how we expect the members of the community will interact
while contributing and communicating.

## Project Structure

The project has a structure is a set of Python3 scripts.

* **[generator.py](generator.py)** file specifies a script that generates an application with the specified settings.
* **[configuration.py](configuration.py)** file specifies the configuration of the generated application.
* **[default_icons](default_icons)** directory contains icons for different screen resolutions for generated Aurora OS Application.
* **[generators](generators)** directory contains templates for generating application files for all versions.
* **[ru_auroraos_WebView](generators/ru_auroraos_WebView)** directory contains templates for generating application files for `ru.auroraos.WebView` version.
* **[Sailfish_WebView](generators/Sailfish_WebView)** directory contains templates for generating application files for `Sailfish.WebView` version.

## Usage

To use the genarator it needs to create the configuration JSON-file that sets properties described below in the "Configuration" section. All properties marked as required must be present.
The launch is carried out by calling the Python interpreter version 3.6+ with the `generator.py` file and the configuration file path:
```
python <path to generator.py> <path to config file>
```

For example:
```
python3 .\generator.py .\template\template.json -p .\template\
```

The generation result will be an Aurora application created according to the configuration and including the following elements:

1. Desktop-file (`*.desktop`).
2. Spec-file (`*.spec`).
3. One qml-file with WebView.
4. One qml-file with application cover.
5. Qml-files with utility components.
6. Applications icons (86x86, 108x108, 128x128, 172x172). If the icons path is not specified by the user, the icons from the template will be used.
7. Pro-file with description of the project structure (`*.pro`).
8. C++ file with the `main()` function (`*.cpp`).
9. Files with the implementation of the corresponding D-Bus service and Push client (if the configuration file contains `push_app_id`).

## Configuration

The configuration JSON-file contains:

1. Meta-information:
    1. [application_name] Application name (required).
    2. [organization_name] Organization name (required).
    3. [summary] Short description (required).
    4. [version] Version (required).
    5. [description] Full description.
    6. [icon] Path to application icons in 86x86, 108x108, 128x128 and 172x172 resolutions.
    7. [application_permission] List of application permissions (required).
    8. [desktop_name] Application name displayed to the user.
2. [webview_version] Defines what version of WebView to use (required):
	* [Sailfish.WebView] Import Webview from Sailfish.Webview
	* [ru.auroraos.WebView] Import Webview from ru.auroraos.WebView
3. [background_activity] Behavior of the application in the background (required):
    * [true] Work in background, display WebView content on cover.
    * [false] Don't run in background (clear webview by timeout when in background).
4. [external_urls] List of regular expressions for URLs that will open in the system browser.
5. [frame_urls] A list of regular expressions for the URLs of embedded `iframe`s that will open in the WebView.
6. [url] Starting address to display in WebView (required).
7. [web_permissions] White list of site permissions that will be automatically accepted [geolocation, microphone, camera, cookie, popup].
8. [user_agent] The User Agent that the WebView will use instead of the default one.
9. [push_app_id] Application ID for receiving push notifications.
10. [push_handler_name] The name of the JavaScript function of the Web page to which the content of the Push notification will be passed.
11. [push_id_injector] A list of objects of the form `{"trigger_on": <replaced_url>, "replace_with": <replacement_url>}` that will define conditions to replace URLs matching the regular expression from `trigger_on` with URLs from `replace_with`. The substitutions will occur when the user navigates to a URL set as `trigger_on`. The URL specified as `replace_with` will be opened instead of this page. If the URL specified as `replace_with` contains the symbols `"%1"`, then the symbols will be replaced with the registration number of the application on the Aurora push server.

### Example

```
{
	"application_name": "DevPortalWEB",
	"organization_name": "auroraos.ru",
	"summary": "A reference WebView wrapper for Aurora OS Developer Portal",
	"version": 1.0,
	"description": "An example of a WebView wrapper generated with a Web App Generator. Provides access to Aurora OS Developer Portal",
	"application_permission":
		[
			"Internet"
		],
	"webview_version": "ru.auroraos.WebView",
	"background_activity": true,
	"url": "https://developer.auroraos.ru/"
}
```

## Building

The generated project can be used just like the one created manually or by the wizard in the Aurora OS SDK. You can either immediately assemble or modify without the help of a generator.

## This document in Russian / Перевод этого документа на русский язык

- [README.ru.md](README.ru.md)

