// SPDX-FileCopyrightText: 2022 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#include <QMutexLocker>

#include <amberpdf/pdfdocument.h>

#include "pagepreloader.h"

QMutex PagePreloader::m_mutex;

PagePreloader::PagePreloader(QSharedPointer<PdfDocument> document, int pageIndex) :
    m_document(document),
    m_pageIndex(pageIndex)
{  }

PagePreloader::~PagePreloader() = default;

void PagePreloader::run()
{
    if (!m_document || m_document->status() != PdfDocument::Success) {
        emit done(m_pageIndex, BaseDocument::PageLoadStatus::Fail);
        return;
    }

    QMutexLocker lock(&m_mutex);
    auto pageFuture = m_document->page(m_pageIndex);
    pageFuture.waitForFinished();
    if (pageFuture.isFinished() && !pageFuture.isCanceled())
        emit done(m_pageIndex, BaseDocument::PageLoadStatus::Success);
    else
        emit done(m_pageIndex, BaseDocument::PageLoadStatus::Fail);
}
