// SPDX-FileCopyrightText: 2022 - 2023 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef DOCUMENTMAPPER_H
#define DOCUMENTMAPPER_H

#include <QQuickItem>
#include <QSizeF>
#include <QPointF>
#include <QHash>
#include <set>
#include <map>

#include "pdfviewtypes.h"

#define SPACING_DEFAULT_VALUE 20

class BaseDocument;
class DocumentMapper : public QQuickItem
{
    Q_OBJECT

public:
    explicit DocumentMapper(QQuickItem *parent = nullptr);

    QSGNode *updatePaintNode(QSGNode *, UpdatePaintNodeData *) override;

    QHash<int, PagePosition> actualMap() const;
    PagePosition actualPagePosition(int pageIndex) const;
    PageGeometry originalPageGeometry(int pageIndex) const;
    QPointF pagePosition(int pageIndex) const;
    qreal contentHeight() const;
    qreal contentWidth() const;
    qreal spacing() const;
    qreal lastPageActualSize() const;
    void forceUpdate();
    bool isIndexSpecal(int pageIndex) const;
    bool isHasSpecial() const;
    int minSpecialIndex() const;
    int maxSpecialIndex() const;
    qreal pageAspectRatio() const;

public slots:
    void setDocumentProvider(BaseDocument *documentProvider);
    void setOrientation(Qt::Orientation orientation);
    void setSpecialPageIndexes(const std::map<int,int> &specialRangeIndexes,
 const std::set<int> &specialIndexes);
    void setPageAspectRatio(qreal pageAspectRatio);
    void setReverse(bool reverse);
    void setSpacing(qreal spacing);

signals:
    void contentWidthChanged(qreal);
    void contentHeightChanged(qreal);
    void mapEnd();

private slots:
    void _mapPages();
    void _updateSize();

private:
    BaseDocument *m_documentProvider;
    PagesMap m_originalPagesMap;
    QHash<int, PagePosition> m_actualPagesCoordinates;
    Qt::Orientation m_orientation;
    qreal m_spacing;
    qreal m_contentHeight;
    qreal m_contentWidth;
    qreal m_lastPageActualSize;
    std::set<int> m_specialIndexes;
    std::map<int,int> m_spacialRangeIndexes;
    qreal m_pageAspectRatio;
    bool m_reverse;
};

#endif // DOCUMENTMAPPER_H
