/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source
**
** This file is part of the AmberPDF-QML-Plugin project.
**
** $QT_BEGIN_LICENSE:BSD$
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Open Mobile Platform LLC copyright holder nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <QQmlExtensionPlugin>
#include <QtQml>

#include "basedocument.h"
#include "pdfview.h"
#include "pdfdocumentitem.h"
#include "bookmarksmodel.h"
#include "pageswithnotesmodel.h"
#include "pagewithnotessortmodel.h"

class Q_DECL_EXPORT AmberpdfQmlPlugin : public QQmlExtensionPlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "ru.omp.amberpdf")
public:
    void initializeEngine(QQmlEngine *engine, const char *uri) override
    {
        Q_UNUSED(uri)
        Q_UNUSED(engine)
    }

    void registerTypes(const char *uri) override
    {
        // @uri ru.omp.amberpdf
        qmlRegisterType<PdfView>(uri, 1, 0, "PdfViewPrivate");
        qmlRegisterType<PdfDocumentItem>(uri, 1, 0, "PdfDocument");
        qmlRegisterType<BookmarksModel>(uri, 1, 0, "BookmarksModel");
        qmlRegisterType<PagesWithNotesModel>(uri, 1, 0, "PagesWithNotesModel");
        qmlRegisterType<PageWithNotesSortModel>(uri, 1, 0, "PageWithNotesSortModel");
        qmlRegisterInterface<BaseDocument>("BaseDocument");
    }
};

#include "plugin.moc"
