/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source
**
** This file is part of the AmberPDF-QML-Plugin project.
**
** $QT_BEGIN_LICENSE:BSD$
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Open Mobile Platform LLC copyright holder nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef PDFPAGETILE_H
#define PDFPAGETILE_H

#include <QQuickItem>
#include <QImage>

class BasePage;
class QTimer;
class QSGTexture;
class QPropertyAnimation;
class PdfPageTile : public QQuickItem
{
    Q_OBJECT

    Q_PROPERTY(bool renderable READ renderable WRITE setRenderable NOTIFY renderableChanged)

public:
    explicit PdfPageTile(QQuickItem *parent = nullptr);
     ~PdfPageTile() override;

    QSGNode *updatePaintNode(QSGNode *oldNode, UpdatePaintNodeData *) override;
    void geometryChanged(const QRectF &newGeometry, const QRectF &oldGeometry) override;

    void setPageSource(QSharedPointer<BasePage> pageSource);
    bool renderable() const;
    bool isBitmap() const;

public slots:
    void setImageScale(qreal imageScale);
    void render();
    void setRenderable(bool renderable);

signals:
    void bitmapError();
    void partReady();
    void animationEnded();
    void renderableChanged(bool renderable);

private slots:
    void _loadBitmap();

private:
    QImage m_pagePart;
    QSharedPointer<BasePage> m_pageSource;
    bool m_needUpdateImage;
    bool m_renderInProcess;
    bool m_renderable;
    QTimer *m_timer;
    qreal m_imageScale;
    QPropertyAnimation *m_animation;
};

#endif // PDFPAGETILE_H
