/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source
**
** This file is part of the AmberPDF-QML-Plugin project.
**
** $QT_BEGIN_LICENSE:BSD$
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Open Mobile Platform LLC copyright holder nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef PDFPAGEITEM_H
#define PDFPAGEITEM_H

#include <QObject>
#include <QSharedPointer>

#include <basepage.h>

class PdfPage;
class BaseAnnotation;
class PdfPageItem : public BasePage
{
    Q_OBJECT
public:
    explicit PdfPageItem(QSharedPointer<PdfPage> amberPage, QObject *parent = nullptr);
    ~PdfPageItem();

    QList<BaseAnnotation *> annotations() const override;
    void loadAnnotations() override;
    bool isAnnotationsSupport() const override;
    int pageNumber() const override;
    QFuture<QSizeF> originalSize() override;
    QFuture<QImage> bitmapFull(qreal pageScale, int renderFlags = 0) const override;
    QFuture<QImage> bitmapPart(qreal pageScaleX, qreal pageScaleY,
                                       int renderFlags = 0, qreal zoom = 1.0,
                                       const QPointF &bias = QPointF()) const override;
    void addAnnotation(const QRectF &rect, const QColor &color,
                                   const QString &author, const QString &content) override;
    void removeAnnotation(int annotationId) override;
    void editNote(int noteId, const QString &newContent, const QColor &newColor) override;

private:
    QSharedPointer<PdfPage> m_amberPage;
    QList<BaseAnnotation *> m_annotations;
};

#endif // PDFPAGEITEM_H
