/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source
**
** This file is part of the AmberPDF-QML-Plugin project.
**
** $QT_BEGIN_LICENSE:BSD$
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Open Mobile Platform LLC copyright holder nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef PDFDOCUMENTITEM_H
#define PDFDOCUMENTITEM_H

#include <QObject>
#include <QSharedPointer>
#include <QHash>
#include <QSet>
#include <QVector>

#include "basedocument.h"
#include "pdfpageitem.h"

class PdfPage;
class PdfDocument;
class PdfDocumentItem : public BaseDocument
{
    Q_OBJECT

public:
    explicit PdfDocumentItem(QObject *parent = nullptr);
    ~PdfDocumentItem();

    QString path() const override;
    QSizeF pageSize(int pageNumber) const override;
    int count() const override;
    QSharedPointer<BasePage> loadPage(int pageIndex) override;
    void startLoadBookmarks() const override;
    QVector<BaseBookmark *> bookmarks() const override;
    int fileVersion() const override;
    bool saveDocumentAs(const QString &path) const override;

public slots:
    void setPath(const QString &path) override;

private:
    QSharedPointer<PdfDocument> m_pdfiumDocument;
    QHash<int, QSizeF> m_pageSizes;
    QHash<int, QSharedPointer<BasePage>> m_loadedPages;
    QSet<int> m_pagesInProcess;
    int m_lastLoadedPage;
    QVector<BaseBookmark *> m_baseBookmarks;
};

#endif // PDFDOCUMENTITEM_H
