/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source
**
** This file is part of the AmberPDF-QML-Plugin project.
**
** $QT_BEGIN_LICENSE:BSD$
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Open Mobile Platform LLC copyright holder nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef PAGEWITHNOTESSORTMODEL_H
#define PAGEWITHNOTESSORTMODEL_H

#include <QSortFilterProxyModel>

class PagesWithNotesModel;
class PageWithNotesSortModel : public QSortFilterProxyModel
{
    Q_OBJECT
    Q_PROPERTY(PagesWithNotesModel *sourceModel READ sourceModel WRITE setSourceModel NOTIFY sourceModelChanged)
    Q_PROPERTY(int filterParameter READ filterParameter WRITE setFilterParameter NOTIFY filterParameterChanged)

public:
    enum FilterParameter {
        None,
        Count
    };
    Q_ENUM(FilterParameter)

    explicit PageWithNotesSortModel(QObject *parent = nullptr);
    PagesWithNotesModel * sourceModel() const;
    int filterParameter() const;

    bool filterAcceptsRow(int source_row, const QModelIndex &source_parent) const override;

public slots:
    void setSourceModel(PagesWithNotesModel *sourceModel);
    void setFilterParameter(int filterParametr);

signals:
    void sourceModelChanged(PagesWithNotesModel * sourceModel);
    void filterParameterChanged(int filterParametr);

private:
    PagesWithNotesModel * m_sourceModel;
    int m_filterParameter;
};

#endif // PAGEWITHNOTESSORTMODEL_H
