/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source
**
** This file is part of the AmberPDF-QML-Plugin project.
**
** $QT_BEGIN_LICENSE:BSD$
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Open Mobile Platform LLC copyright holder nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef BASEPAGE_H
#define BASEPAGE_H

#include <QObject>
#include <QSizeF>
#include <QFuture>
#include <QPointF>

class BaseAnnotation;
class BasePage : public QObject
{
    Q_OBJECT

public:
    explicit BasePage(QObject *parent = nullptr);
    virtual ~BasePage();

    virtual QList<BaseAnnotation *> annotations() const = 0;
    virtual void loadAnnotations() = 0;
    virtual bool isAnnotationsSupport() const = 0;
    virtual int pageNumber() const = 0;
    virtual QFuture<QSizeF> originalSize() = 0;
    virtual QFuture<QImage> bitmapFull(qreal pageScale, int renderFlags = 0) const = 0;
    virtual QFuture<QImage> bitmapPart(qreal pageScaleX, qreal pageScaleY,
                                       int renderFlags = 0, qreal zoom = 1.0,
                                       const QPointF &bias = QPointF()) const = 0;
    virtual void addAnnotation(const QRectF &rect, const QColor &color,
                                       const QString &author, const QString &content) = 0;
    virtual void removeAnnotation(int annotationId) = 0;
    virtual void editNote(int noteId, const QString &newContent, const QColor &newColor) = 0;

signals:
    void annotationsLoaded();
    void originalSizeLoaded();
    void annotationAdded(bool);
    void annotationDelete(int, bool);
    void annotationEdited(int, bool);
};

#endif // BASEPAGE_H
