/****************************************************************************
**
** Copyright (C) 2022 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source
**
** This file is part of the AmberPDF-QML-Plugin project.
**
** $QT_BEGIN_LICENSE:BSD$
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Open Mobile Platform LLC copyright holder nor
**     the names of its contributors may be used to endorse or promote
**     products derived from this software without specific prior written
**     permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef BASEDOCUMENT_H
#define BASEDOCUMENT_H

#include <QObject>
#include <QSharedPointer>

class BasePage;
class BaseBookmark;
class BaseDocument : public QObject
{
    Q_OBJECT

    Q_PROPERTY(DocumentStatus status READ status NOTIFY statusChanged)
    Q_PROPERTY(QString path READ path WRITE setPath NOTIFY pathChanged)

public:
    enum class DocumentStatus
    {
        Null,
        Loading,
        Ready,
        Error
    };
    Q_ENUM(DocumentStatus)

    enum class PageLoadStatus
    {
        Success,
        Fail
    };
    Q_ENUM(PageLoadStatus)

    explicit BaseDocument(QObject *parent = nullptr);
    virtual ~BaseDocument();

    DocumentStatus status() const;

    virtual QString path() const;
    virtual QSizeF pageSize(int pageNumber) const = 0;
    virtual int count() const = 0;
    virtual QSharedPointer<BasePage> loadPage(int pageIndex) = 0;
    virtual void startLoadBookmarks() const = 0;
    virtual QVector<BaseBookmark *> bookmarks() const = 0;
    virtual int fileVersion() const = 0;
    virtual bool saveDocumentAs(const QString &path) const = 0;

public slots:
    virtual void setPath(const QString &path) = 0;

signals:
    void statusChanged(DocumentStatus status);
    void pathChanged(const QString &path);
    void pageLoaded(int pageNumber, PageLoadStatus loadStatus);
    void bookmarksLoaded();
    void fileVersionChanged(int version);

protected:
    DocumentStatus m_status;
    QString m_path;
};

#endif // BASEDOCUMENT_H
