#############################################################################
##
## Copyright (C) 2022 Open Mobile Platform LLC.
## Contact: https://community.omprussia.ru/open-source
##
## This file is part of the AmberPDF-QML-Plugin project.
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions are
## met:
##   * Redistributions of source code must retain the above copyright
##     notice, this list of conditions and the following disclaimer.
##   * Redistributions in binary form must reproduce the above copyright
##     notice, this list of conditions and the following disclaimer in
##     the documentation and/or other materials provided with the
##     distribution.
##   * Neither the name of Open Mobile Platform LLC copyright holder nor
##     the names of its contributors may be used to endorse or promote
##     products derived from this software without specific prior written
##     permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
## "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
## TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
## PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL OPEN MOBILE PLATFORM LLC OR
## CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
## EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
## PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
## PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
## LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
## NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
## SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
#############################################################################

TEMPLATE = lib
QT += qml quick
QT -= gui
CONFIG += qt plugin hide_symbols c++17 link_pkgconfig

LIBS += -lamberpdf

TARGET = $$qtLibraryTarget(amberpdfqmlplugin)
target.path = $$[QT_INSTALL_QML]/ru/omp/amberpdf

qml.files = qmldir *.qml plugins.qmltypes
qml.path = $$[QT_INSTALL_QML]/ru/omp/amberpdf

INSTALLS = target qml

VIEW_HEADERS += \
    src/interface/basedocument.h \
    src/interface/basepage.h \
    src/bitmaploadworker.h \
    src/pdfpagetile.h \
    src/pdfviewtypes.h \
    src/pdfpagecontainer.h \
    src/documentmapper.h \
    src/pdfview.h \
    src/interface/baseannotation.h \
    src/pdfsimpleannotation.h \
    src/pdfsimplenote.h \
    src/bookmarksmodel.h \
    src/interface/basebookmark.h \
    src/notesmodel.h \
    src/pageswithnotesmodel.h \
    src/pagewithnotessortmodel.h \

PROVIDER_HEADERS += \
    src/pdfium-provider/pagepreloader.h \
    src/pdfium-provider/pagessizesloader.h \
    src/pdfium-provider/pdfdocumentitem.h \
    src/pdfium-provider/pdfpageitem.h \

VIEW_SOURCES += \
    src/interface/basedocument.cpp \
    src/interface/basepage.cpp \
    src/bitmaploadworker.cpp \
    src/pdfpagetile.cpp \
    src/pdfpagecontainer.cpp \
    src/documentmapper.cpp \
    src/pdfview.cpp \
    src/interface/baseannotation.cpp \
    src/pdfsimpleannotation.cpp \
    src/pdfsimplenote.cpp \
    src/bookmarksmodel.cpp \
    src/notesmodel.cpp \
    src/pageswithnotesmodel.cpp \
    src/pagewithnotessortmodel.cpp \

PROVIDER_SOURCES += \
    src/pdfium-provider/pagepreloader.cpp \
    src/pdfium-provider/pagessizesloader.cpp \
    src/pdfium-provider/pdfdocumentitem.cpp \
    src/pdfium-provider/pdfpageitem.cpp \

HEADERS += \
    $$PROVIDER_HEADERS \
    $$VIEW_HEADERS \

SOURCES += \
    $$PROVIDER_SOURCES \
    $$VIEW_SOURCES \
    src/plugin.cpp \

INCLUDEPATH += \
    src \
    src/interface \
    src/pdfium-provider \

DISTFILES += *.qml

DEFINES += \
    PRELOAD_PAGES_COUNT=10 \
    HIGHLIGHT_OPACITY_ANNOT_ON=178 \
    HIGHLIGHT_OPACITY_ANNOT_OFF=42 \
    HIGHLIGHT_OPACITY_NOTE_ON=198 \
    HIGHLIGHT_OPACITY_NOTE_OFF=100 \

qmltypes.commands = qmlplugindump -nonrelocatable ru.omp.amberpdf 1.0 > $$PWD/plugins.qmltypes
QMAKE_EXTRA_TARGETS += qmltypes
