/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.gen

import ru.aurora.kmp.qtbindings.ksp.capitalizeFirstChar

internal class VariableScope {
    private var names = mutableSetOf<String>()

    fun forceAdd(varName: String) {
        if (!names.add(varName)) throw IllegalStateException("Cannot add variable '$varName' to scope, it already exists")
    }

    fun overrideAdd(varName: String) = names.add(varName)

    fun generate(varName: String): String {

        if (names.add(varName)) {
            return varName
        }

        var generatedName = varName

        for (i in 1..Long.MAX_VALUE) {
            generatedName = "$varName$i"
            if (names.add(generatedName)) {
                break
            }
        }

        return generatedName
    }

    // Add "qt" prefix, remove 'kotlin' prefix if it exists
    fun generateQt(varName: String): String {
        if (varName.startsWith("qt")) return generate(varName)
        val newName = varName.removePrefix("kotlin")
        return generate("qt${newName.capitalizeFirstChar()}")
    }

    // Add "kotlin" prefix, remove 'qt' prefix if it exists
    fun generateKotlin(varName: String): String {
        if (varName.startsWith("kotlin"))  return generate(varName)
        val newName = varName.removePrefix("qt")
        return generate("kotlin${newName.capitalizeFirstChar()}")
    }

    fun scope(block: VariableScope.() -> Unit) {
        val oldNames = names.toMutableSet()
        block()
        names = oldNames
    }
}
