/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.export

internal enum class AccessorType {
    Getter, Setter,
}

/**
 * Describes kotlin property that needs to be exported to Qt.
 * Setter is exported as setPropertyName.
 * Getter is exported as getPropertyName.
 */
internal class ExportedProperty(
    val name: String,
    val type: ExportedType,
    val accessor: AccessorType,
    val parentClass: ExportedClass,
    val extensionReceiver: ExportedParameter?,
) {
    val fqName = "${parentClass.fqName}.$name"
}
