/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.internal

import java.io.File

class NativeProcessRunner(val executable: File) {
    fun run(env: Map<String, String> = emptyMap()): ProcessResult {
        val process = ProcessBuilder(executable.absolutePath)
            .directory(executable.parentFile)
            .apply { environment().putAll(env) }
            .start()

        val exitCode = process.waitFor()
        val stdout = process.inputStream.bufferedReader().readText()
        val stderr = process.errorStream.bufferedReader().readText()
        return ProcessResult(executable, exitCode, stdout, stderr)
    }
}
