/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp

import com.tschuchort.compiletesting.SourceFile
import org.jetbrains.kotlin.compiler.plugin.ExperimentalCompilerApi
import kotlin.io.path.Path
import kotlin.test.Test

@OptIn(ExperimentalCompilerApi::class)
class TopLevelFunctionTests : BaseCompilationTest() {

        @Test
        fun `check that public top-level function can be exported`() {
            val source = SourceFile.new(
                "TopLevelFunction.kt","""
                package test

                import ru.aurora.kmp.qtbindings.QtExport

                @QtExport
                fun sum(x: Int, y: Int) : Int {
                    return x + y
                }
                """.trimIndent()
            )

            val cppHeader = GeneratedFile(
                Path("test", "TopLevelFunction.hpp"), """
                // Generated code, DO NOT EDIT IT MANUALLY!
                
                #ifndef TEST_TOP_LEVEL_FUNCTION_HPP
                #define TEST_TOP_LEVEL_FUNCTION_HPP
                
                #include "libshared_api.h"
                
                namespace test {
                
                int sum(int x, int y);
                
                } /* namespace test */
                
                #endif /* TEST_TOP_LEVEL_FUNCTION_HPP */
                """.trimIndent()
            )

            run(source, cppHeader)
        }
}
