/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.model

internal data class QtClass(
    val name: String,
    val ns: QtNamespace,
    val hasCopyMethod: Boolean,
    val methods: List<QtMethod>,
) {
    val fqName = (ns.components + name).joinToString("::")
}
