/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.gen

import ru.aurora.kmp.qtbindings.ksp.model.QtParameter
import ru.aurora.kmp.qtbindings.ksp.model.QtType

internal fun QtParameter.toFunctionParameter() : String {
    return when (type) {
        is QtType.Collection.QList, is QtType.Class, is QtType.Primitive.QString -> "const ${type.name} &$name"
        else -> "${type.name} $name"
    }
}

internal fun QtType.toReturnType(isReturningAsynchronously: Boolean) = if (isReturningAsynchronously) "QFuture<$name>" else name
