/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.gen

internal data class CppFile(
    val packageName: String,
    val fileName: String,
    val fileExtension: String,
    val fileContent: String?,
)

internal class QtRuntimeGenerator {

    private val packageName = "ru.aurora.kmp.qtbindings"
    private val fileDirectory = "/${packageName.replace(".", "/")}"

    private val headers = listOf(
        "CallbackContext.hpp",
        "CoroutineException.hpp",
        "CoroutineLauncher.hpp",
        "CoroutineOperation.hpp",
        "cruntime.h"
    )

    private val sources = listOf(
        "CallbackContext.cpp",
        "CoroutineException.cpp",
        "CoroutineLauncher.cpp",
    )

    fun generate(): List<CppFile> {
        return (headers + sources).map {
            val filePath = fileDirectory.plus("/${it}")
            val fileNameWithoutExtension = it.getName()
            val fileExtension = it.getExtension()
            val resource = javaClass.getResourceAsStream(filePath)
            val content = resource?.bufferedReader()?.use { reader -> reader.readText() }
            CppFile(packageName, fileNameWithoutExtension, fileExtension, content)
        }
    }
}

private fun String.getExtension(): String {
    return this.substringAfterLast('.')
}

private fun String.getName(): String {
    return this.substringBeforeLast('.')
}
